/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared;

import com.binfer.base.service.IDatabaseService;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.LogService;
import com.binfer.base.service.TransfersService;
import com.binfer.base.util.GenericPlatformService;
import com.binfer.core.service.BinferService;
import com.binfer.core.service.IService;
import com.binfer.desktop.shared.IBinfer;
import com.binfer.persistence.sql.service.SQLService;
import com.binfer.providers.h2.H2Provider;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;

public class HttpServer {
    private IService service;

    public void start(Map<String, String> props) throws Exception {
        File systemDir = new File(props.get(IPreferences.SYSTEMPATH));
        File dataDir = new File(props.get(IPreferences.DOWNLOADPATH));
        LogService.setLogger(systemDir, "binfer", IBinfer.defaultLevel);
        GenericPlatformService platformService = new GenericPlatformService(systemDir, dataDir);
        H2Provider dbs = new H2Provider();
        SQLService persistenceService = new SQLService((IDatabaseService)dbs);
        BinferService binferService = new BinferService(persistenceService, platformService);
        binferService.login(props);
        this.service = binferService.getService();
        TransfersService.getInstance().init(100);
        TransfersService.getInstance().start();
        LogService.log("started embedded server with props:" + props, Level.WARNING);
    }

    public void stop() {
        try {
            LogService.log("stopped embedded server", Level.WARNING);
            this.service.logout();
        }
        catch (Throwable testMode) {
        }
        finally {
            String testMode = System.getProperty("binfer.testMode");
            if (testMode == null || testMode.trim().isEmpty()) {
                System.exit(0);
            }
        }
    }

    public IService getCoreService() {
        return this.service;
    }
}

