/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared;

import com.binfer.base.service.DownloadService;
import com.binfer.base.service.EventService;
import com.binfer.base.service.ICallback;
import com.binfer.base.service.IEvent;
import com.binfer.base.service.IMessage;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.util.StringUtil;
import com.binfer.base.util.Xfer;
import com.binfer.core.service.IService;
import com.binfer.desktop.shared.BinferApplication;
import com.binfer.desktop.shared.Notification;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.swing.AbstractAction;

public class SystemTrayHelper {
    private TrayIcon trayIcon;
    private Stage stage;
    private IService service;
    ICallback<IEvent.EVENT, Object> callback = new ICallback<IEvent.EVENT, Object>(){

        @Override
        public void handleEvent(IEvent.EVENT event, Object arg) {
            try {
                switch (event) {
                    case CONNECTIONSTATUSCHANGED: {
                        break;
                    }
                    case FILERECEIVED: {
                        SystemTrayHelper.this.bringToFrontFocus();
                        Xfer xfer_r = (Xfer)Xfer.class.cast(arg);
                        SystemTrayHelper.this.setNotfn("File received", xfer_r.filename + " received from " + SystemTrayHelper.this.service.getContactsService().getFirstName(xfer_r.from), Notification.TYPE.INFO);
                        break;
                    }
                    case FILESENT: {
                        Xfer xfer_s = (Xfer)Xfer.class.cast(arg);
                        File thumbnailsDir = null;
                        try {
                            thumbnailsDir = DownloadService.getThumbnailsDir();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String thumbnailDirPath = "";
                        if (thumbnailsDir != null) {
                            thumbnailDirPath = thumbnailsDir.getAbsolutePath();
                        }
                        if (xfer_s.file.getAbsolutePath().startsWith(thumbnailDirPath)) break;
                        if (xfer_s.from.equalsIgnoreCase(xfer_s.to)) {
                            SystemTrayHelper.this.setNotfn("File sent", xfer_s.filename + " sent to " + xfer_s.contactIP, Notification.TYPE.INFO);
                            break;
                        }
                        SystemTrayHelper.this.setNotfn("File sent", xfer_s.filename + " sent to " + SystemTrayHelper.this.service.getContactsService().getFirstName(xfer_s.to), Notification.TYPE.INFO);
                        break;
                    }
                    case QUOTAFINISHED: {
                        SystemTrayHelper.this.setNotfn("License limit reached", SystemTrayHelper.this.service.getLicenseService().getLicenseOverMessage(), Notification.TYPE.WARNING);
                        break;
                    }
                    case MESSAGE: {
                        Map vals = (Map)arg;
                        if (((String)vals.get(IMessage.DESCRIPTION)).isEmpty() || !((String)vals.get(IMessage.FLOW)).equalsIgnoreCase(Byte.toString((byte)0))) break;
                        SystemTrayHelper.this.bringToFrontFocus();
                        SystemTrayHelper.this.setNotfn("Chat", SystemTrayHelper.this.service.getContactsService().getFirstName((String)vals.get(IUser.USERID)) + " says " + new StringUtil().shorten((String)vals.get(IMessage.DESCRIPTION), 100), Notification.TYPE.INFO);
                        break;
                    }
                    case PENDINGCONNECTION: {
                        try {
                            Map contact = (Map)Map.class.cast(arg);
                            SystemTrayHelper.this.setNotfn("Pending connection requests", (String)contact.get(IUser.USERID), Notification.TYPE.INFO);
                        }
                        catch (Exception contact) {}
                        break;
                    }
                    case LICENSEREFRESHED: {
                        break;
                    }
                    case WEBDROPDISABLED: {
                        if (arg == null) break;
                        SystemTrayHelper.this.setNotfn("Web Drop disabled", arg.toString(), Notification.TYPE.ERROR);
                        break;
                    }
                    case PROBLEM: {
                        if (arg == null) break;
                        SystemTrayHelper.this.setNotfn("Problem", arg.toString(), Notification.TYPE.ERROR);
                        break;
                    }
                    case ACCOUNTDEACTIVATED: {
                        BinferApplication.getInstance().showError("Account has been deactivated");
                        BinferApplication.getInstance().logout(false);
                        break;
                    }
                    case FORCELOGOUT: {
                        BinferApplication.getInstance().logout(false);
                        break;
                    }
                    case NOTIFY: {
                        try {
                            String subject = "";
                            String desc = "";
                            if (arg instanceof Map) {
                                Map _arg = (Map)arg;
                                desc = _arg.get(ISpace.DESCRIPTION).toString();
                                subject = _arg.get(ISpace.SUBJECT).toString();
                            } else {
                                subject = event.name();
                                desc = arg.toString();
                            }
                            try {
                                StringUtil su = new StringUtil();
                                desc = su.shorten(su.stripHTML(desc), 100);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (desc == null) {
                                desc = "";
                            }
                            SystemTrayHelper.this.setNotfn(subject, desc, Notification.TYPE.INFO);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public SystemTrayHelper(Stage stage, IService service) {
        this.stage = stage;
        this.service = service;
        try {
            Toolkit.getDefaultToolkit();
            if (!SystemTray.isSupported()) {
                LogService.log("System does not support tray", Level.SEVERE);
                return;
            }
            Platform.setImplicitExit((boolean)false);
            PopupMenu popup = new PopupMenu();
            Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/icons/logo48.png"));
            this.trayIcon = new TrayIcon(image, "Binfer", popup);
            this.trayIcon.setImageAutoSize(true);
            SystemTray tray = SystemTray.getSystemTray();
            MenuItem bring_to_front_menuitem = new MenuItem("Bring to front");
            popup.add(bring_to_front_menuitem);
            bring_to_front_menuitem.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SystemTrayHelper.this.bringToFront();
                }
            });
            MenuItem quit_menuitem = new MenuItem("Quit");
            popup.add(quit_menuitem);
            quit_menuitem.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BinferApplication.getInstance().logout(true);
                }
            });
            this.trayIcon.setPopupMenu(popup);
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SystemTrayHelper.this.bringToFront();
                }
            });
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (System.getProperty("os.name").contains("ind")) {
            // empty if block
        }
    }

    public void close() {
        EventService.unSubscribe(IEvent.EVENT.NOTIFY, this.callback);
        Platform.exit();
    }

    private void bringToFront() {
        try {
            Platform.runLater(() -> {
                this.stage.show();
                this.stage.requestFocus();
                this.stage.toFront();
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void bringToFrontFocus() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SystemTrayHelper.this.stage.requestFocus();
            }
        });
    }

    public void setNotfn(final String caption, final String message, final Notification.TYPE type) {
        try {
            if (SystemTray.isSupported()) {
                if (Platform.isFxApplicationThread()) {
                    this._setNotfn(caption, message, type);
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SystemTrayHelper.this._setNotfn(caption, message, type);
                        }
                    });
                }
            } else {
                LogService.log("systray notifications not supported.message:" + caption + ", " + message, Level.WARNING);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void _setNotfn(String caption, String message, Notification.TYPE _type) {
        try {
            Notification notfn = new Notification(caption, message, _type);
            TrayIcon.MessageType type = TrayIcon.MessageType.INFO;
            switch (notfn.type) {
                case ERROR: {
                    type = TrayIcon.MessageType.ERROR;
                    break;
                }
                case INFO: {
                    type = TrayIcon.MessageType.INFO;
                    break;
                }
                case WARNING: {
                    type = TrayIcon.MessageType.WARNING;
                }
            }
            this.trayIcon.displayMessage(notfn.caption, notfn.message, type);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

