/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.image;

import com.binfer.base.service.DownloadService;
import com.binfer.desktop.shared.image.IImageUtil;
import com.binfer.desktop.shared.image.ImageUtilJPG;
import com.binfer.desktop.shared.image.ImageUtilPNG;
import java.io.File;

public class ImageUtil {
    public static String getThumbnailBase64(File sourceImage, int dstWidth, int dstHeight, IImageUtil.FORMAT format) throws Exception {
        switch (format) {
            case PNG: {
                return ImageUtilPNG.getThumbnailBase64(sourceImage, dstWidth, dstHeight);
            }
        }
        return ImageUtilJPG.getThumbnailBase64(sourceImage, dstWidth, dstHeight);
    }

    public static void createThumbnail(File sourceImage, File destinationImage, int dstWidth, int dstHeight, IImageUtil.FORMAT format) throws Exception {
        switch (format) {
            case PNG: {
                if (destinationImage == null) {
                    destinationImage = DownloadService.getThumbnailFile(new File(sourceImage.getName() + "." + format.name()));
                }
                ImageUtilPNG.createThumbnail(sourceImage, destinationImage, dstWidth, dstHeight);
            }
        }
        if (destinationImage == null) {
            destinationImage = DownloadService.getThumbnailFile(sourceImage);
        }
        ImageUtilJPG.createThumbnail(sourceImage, destinationImage, dstWidth, dstHeight);
        if (destinationImage.length() == 0L) {
            destinationImage.delete();
        }
    }

    public static File getThumbnailFile(File sourceImage, int dstWidth, int dstHeight, IImageUtil.FORMAT format) throws Exception {
        switch (format) {
            case PNG: {
                return DownloadService.getThumbnailFile(new File(sourceImage.getName() + ".png"));
            }
        }
        return DownloadService.getThumbnailFile(new File(sourceImage.getName() + ".jpg"));
    }
}

