/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.image;

import com.binfer.base.service.DownloadService;
import com.binfer.base.util.Base64;
import com.binfer.desktop.shared.image.IImageUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

class ImageUtilJPG
implements IImageUtil {
    static final String formatName = "jpg";

    ImageUtilJPG() {
    }

    public static String getThumbnailBase64(File sourceImage, int dstWidth, int dstHeight) throws Exception {
        Base64 base64 = new Base64();
        File file_tn = DownloadService.getThumbnailFile(new File(sourceImage.getName() + "." + formatName));
        if (!file_tn.exists()) {
            File destinationImage = DownloadService.getThumbnailFile(sourceImage);
            ImageUtilJPG.createThumbnail(sourceImage, destinationImage, dstWidth, dstHeight);
        }
        byte[] encoded = Files.readAllBytes(file_tn.toPath());
        String encodedImg = new String(base64.encode(encoded));
        return encodedImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createThumbnail(File sourceImage, File destinationImage, int dstWidth, int dstHeight) throws Exception {
        FileInputStream source = null;
        OutputStream destination = null;
        try {
            source = new FileInputStream(sourceImage);
            destination = new FileOutputStream(destinationImage);
            ImageUtilJPG.scale(source, destination, dstWidth, dstHeight, IImageUtil.QUALITY.HIGH, sourceImage.length());
            if (destinationImage.length() > 307200L) {
                destination.close();
                ((InputStream)source).close();
                source = new FileInputStream(sourceImage);
                destination = new FileOutputStream(destinationImage);
                ImageUtilJPG.scale(source, destination, dstWidth / 2, dstHeight / 2, IImageUtil.QUALITY.HIGH, sourceImage.length());
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                destination.flush();
                destination.close();
            }
            catch (Exception exception) {}
            try {
                ((InputStream)source).close();
            }
            catch (Exception exception) {}
        }
    }

    public static File getThumbnailFile(File sourceImage, int dstWidth, int dstHeight) throws Exception {
        return DownloadService.getThumbnailFile(sourceImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void scale(InputStream source, OutputStream destination, int width, int height, IImageUtil.QUALITY quality, long sourceLength) throws Exception {
        try {
            switch (quality) {
                case HIGH: {
                    ImageUtilJPG.scaleHQ(source, destination, width, height, sourceLength);
                    return;
                }
                case MEDIUM: {
                    ImageUtilJPG.scaleMQ1(source, destination, width, height);
                    return;
                }
                case LOW: {
                    ImageUtilJPG.scaleLQ2(source, destination, width, height);
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            try {
                destination.flush();
                destination.close();
            }
            catch (Exception exception) {}
            try {
                source.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void scaleHQ(InputStream source, OutputStream destination, int newWidth, int newHeight, long sourcelength) throws Exception {
        ImageInputStream iis = ImageIO.createImageInputStream(source);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
        if (!iter.hasNext()) {
            return;
        }
        ImageReader reader = iter.next();
        ImageReadParam params = reader.getDefaultReadParam();
        reader.setInput(iis, true, true);
        if (sourcelength > 0x100000L) {
            params.setSourceSubsampling(5, 5, 0, 0);
        } else if (sourcelength > 0x400000L) {
            params.setSourceSubsampling(10, 10, 0, 0);
        } else if (sourcelength > 0xA00000L) {
            params.setSourceSubsampling(20, 20, 0, 0);
        } else if (sourcelength > 0xF00000L) {
            params.setSourceSubsampling(25, 25, 0, 0);
        } else if (sourcelength > 0x200000L) {
            params.setSourceSubsampling(30, 30, 0, 0);
        } else if (sourcelength > 0x1900000L) {
            params.setSourceSubsampling(60, 60, 0, 0);
        }
        BufferedImage image = reader.read(0, params);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        Dimension d = ImageUtilJPG.getScaledDim(imageWidth, imageHeight, newWidth, newHeight);
        BufferedImage img = new BufferedImage(d.width, d.height, 1);
        img.createGraphics().drawImage(image.getScaledInstance(d.width, d.height, 4), 0, 0, null);
        ImageIO.write((RenderedImage)img, formatName, destination);
    }

    public static void scaleHQ1(InputStream source, OutputStream destination, int newWidth, int newHeight) throws Exception {
        BufferedImage image = ImageIO.read(source);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        Dimension d = ImageUtilJPG.getScaledDim(imageWidth, imageHeight, newWidth, newHeight);
        BufferedImage img = new BufferedImage(d.width, d.height, 1);
        img.createGraphics().drawImage(image.getScaledInstance(d.width, d.height, 4), 0, 0, null);
        ImageIO.write((RenderedImage)img, formatName, destination);
    }

    public static void scaleMQ1(InputStream source, OutputStream destination, int newWidth, int newHeight) throws Exception {
        System.setProperty("java.awt.headless", "true");
        BufferedImage image = ImageIO.read(source);
        Dimension d = ImageUtilJPG.getScaledDim(image.getWidth(), image.getHeight(), newWidth, newHeight);
        int width = image.getWidth();
        int height = image.getHeight();
        newWidth = d.width;
        newHeight = d.height;
        BufferedImage thumb = image;
        boolean i = false;
        do {
            if (width > newWidth && (width /= 2) < newWidth) {
                width = newWidth;
            }
            if (height > newHeight && (height /= 2) < newHeight) {
                height = newHeight;
            }
            BufferedImage temp = new BufferedImage(width, height, image.getType());
            Graphics2D g = temp.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(thumb, 0, 0, temp.getWidth(), temp.getHeight(), null);
            g.dispose();
            thumb = temp;
        } while (width != newWidth || height != newHeight);
        ImageIO.write((RenderedImage)thumb, formatName, destination);
        thumb = null;
        image = null;
    }

    private static void scaleLQ2(InputStream source, OutputStream destination, int newWidth, int newHeight) throws Exception {
        Graphics2D g = null;
        BufferedImage image = ImageIO.read(source);
        Dimension d = ImageUtilJPG.getScaledDim(image.getWidth(), image.getHeight(), newWidth, newHeight);
        BufferedImage bdest = new BufferedImage(d.width, d.height, 1);
        g = bdest.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform at = AffineTransform.getScaleInstance(d.getWidth() / (double)image.getWidth(), d.getHeight() / (double)image.getHeight());
        g.drawRenderedImage(image, at);
        ImageIO.write((RenderedImage)bdest, formatName, destination);
        g.dispose();
        image = null;
        bdest = null;
    }

    public static Dimension getScaledDim(double originalWidth, double originalHeight, int preferredWidth, int preferredHeight) {
        Dimension d = new Dimension();
        double scaleFactor = (double)preferredHeight / originalHeight;
        d.setSize(originalWidth *= scaleFactor, originalHeight *= scaleFactor);
        if (d.width > preferredWidth) {
            double aspect = originalHeight / originalWidth;
            int diff = d.width - preferredWidth;
            d.setSize(d.getWidth() - (double)diff, d.getHeight() - (double)diff * aspect);
        }
        return d;
    }
}

