/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.image;

import com.binfer.base.service.DownloadService;
import com.binfer.base.util.Base64;
import com.binfer.desktop.shared.image.IImageUtil;
import com.binfer.desktop.shared.image.PngEncoderFX;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javafx.scene.image.Image;

class ImageUtilPNG
implements IImageUtil {
    static final String formatName = "png";

    ImageUtilPNG() {
    }

    public static String getThumbnailBase64(File sourceImage, int dstWidth, int dstHeight) throws Exception {
        Base64 base64 = new Base64();
        File file_tn = DownloadService.getThumbnailFile(new File(sourceImage.getName() + "." + formatName));
        if (!file_tn.exists()) {
            File destinationImage = DownloadService.getThumbnailFile(new File(sourceImage.getName() + "." + formatName));
            ImageUtilPNG.createThumbnail(sourceImage, destinationImage, dstWidth, dstHeight);
        }
        Image image = new Image(file_tn.toURI().toString().toString());
        PngEncoderFX pefx = new PngEncoderFX(image, true, 0, 9);
        byte[] encoded = pefx.pngEncode();
        String encodedImg = new String(base64.encode(encoded));
        return encodedImg;
    }

    public static void createThumbnail(File sourceImage, File destinationImage, int dstWidth, int dstHeight) throws Exception {
        Image image = null;
        try {
            image = new Image(sourceImage.toURI().toURL().toString(), (double)dstWidth, (double)dstHeight, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PngEncoderFX pefx = new PngEncoderFX(image, true, 0, 9);
        byte[] encoded = pefx.pngEncode();
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destinationImage));
            out.write(encoded);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getThumbnailFile(File sourceImage, int dstWidth, int dstHeight) throws Exception {
        return DownloadService.getThumbnailFile(new File(sourceImage.getName() + "." + formatName));
    }
}

