/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.files;

import com.binfer.base.service.IFile;
import com.binfer.base.service.IOService;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;

public class FileTableModel {
    public SimpleStringProperty folderName = new SimpleStringProperty();
    public SimpleStringProperty fileName = new SimpleStringProperty();
    public SimpleStringProperty size = new SimpleStringProperty();
    public SimpleStringProperty date = new SimpleStringProperty();
    public SimpleBooleanProperty selectcheckbox = new SimpleBooleanProperty();
    public final File file;
    public final Map<String, String> fileMap = new HashMap<String, String>();

    public FileTableModel(Map<String, String> file) {
        this(new File(file.get(IFile.URI)));
        this.fileMap.putAll(file);
    }

    public FileTableModel(File file) {
        this.file = file;
        this.folderName.set(file.getParentFile().getName());
        this.fileName.set(file.getName());
        this.size.set(IOService.bytesToFriendlyString(file.length()));
        this.date.set(new Date(file.lastModified()).toString());
        this.fileMap.put(IFile.URI, file.getAbsolutePath());
        this.fileMap.put(IFile.CREATED, Long.toString(file.lastModified()));
        this.fileMap.put(IFile.MODIFIED, Long.toString(file.lastModified()));
        this.fileMap.put(IFile.SIZE, Long.toString(file.length()));
    }

    public SimpleBooleanProperty selectedProperty() {
        return this.selectcheckbox;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName.get();
    }

    public void setFileName(String name) {
        this.fileName.set(name);
    }

    public String getFolderName() {
        return this.folderName.get();
    }

    public void setFolderName(String email) {
        this.folderName.set(email);
    }

    public String getDate() {
        return this.date.get();
    }

    public void setDate(String date) {
        this.date.set(date);
    }

    public String getSize() {
        return this.size.get();
    }

    public void setSize(String size) {
        this.size.set(size);
    }

    public boolean getSelected() {
        return this.selectcheckbox.get();
    }

    public void setSelected(boolean selectcheckbox) {
        this.selectcheckbox.set(selectcheckbox);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileTableModel) {
            FileTableModel ct = (FileTableModel)FileTableModel.class.cast(obj);
            return ct.file.getAbsolutePath().equalsIgnoreCase(this.file.getAbsolutePath());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.file.toString();
    }
}

