/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.files;

import com.binfer.base.service.ICallback;
import com.binfer.base.service.IEvent;
import com.binfer.base.service.IFile;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.util.IPagedResult;
import com.binfer.core.service.IService;
import com.binfer.desktop.shared.BinferApplication;
import com.binfer.desktop.shared.ui.IView;
import com.binfer.desktop.shared.ui.files.FileTableModel;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class PagedFilesController
implements Initializable,
IView {
    public static final String VIEW_SHARED_PAGED_FILES = "/com/binfer/desktop/shared/ui/files/pagedfiles.fxml";
    Map<String, String> params;
    IPagedResult pr;
    ObservableList<FileTableModel> filesList = FXCollections.observableArrayList();
    AtomicBoolean isRefreshing = new AtomicBoolean(false);
    ICallback<IEvent.EVENT, Object> callback;
    private IService service;
    @FXML
    private TableView<FileTableModel> filesTableView;
    @FXML
    private TableColumn<FileTableModel, String> folderNameColumn;
    @FXML
    private TableColumn<FileTableModel, String> fileNameColumn;
    @FXML
    private TableColumn<FileTableModel, String> sizeColumn;
    @FXML
    private TableColumn<FileTableModel, String> dateColumn;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.folderNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("folderName"));
            this.fileNameColumn.setCellValueFactory((Callback)new PropertyValueFactory("fileName"));
            this.sizeColumn.setCellValueFactory((Callback)new PropertyValueFactory("size"));
            this.dateColumn.setCellValueFactory((Callback)new PropertyValueFactory("date"));
            this.filesTableView.setItems(this.filesList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setService(IService service) {
        this.service = service;
    }

    @Override
    public void onCreate(Object data) {
        this.refresh(data);
    }

    @Override
    public void onDestroy(Object data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void refresh(Object data) {
        try {
            this.params = (Map)Map.class.cast(data);
            this.refresh();
        }
        catch (Exception e) {
            LogService.log("failed to display files because " + e.getMessage(), Level.SEVERE);
        }
    }

    @FXML
    private void handlePreviousClicked(ActionEvent event) {
        try {
            this.updateTable(this.pr.previous());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    private void handleNextClicked(ActionEvent event) {
        try {
            this.updateTable(this.pr.next());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    private void handleRefreshClicked(ActionEvent event) {
        this.refresh();
    }

    public void refresh() {
        this.filesList.clear();
        try {
            byte status = Byte.parseByte(this.params.get(IFile.STATUS));
            int maxCount = Integer.parseInt(this.params.get(IFile.COUNT));
            this.pr = this.service.getFilesService().getFilesByStatus(IUser.CREATED, true, status, (long)maxCount);
            this.updateTable(this.pr.next());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.updateTable(this.pr.previous());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    private void handleRemoveClicked(ActionEvent event) {
        if (this.callback != null) {
            FileTableModel ftm = (FileTableModel)this.filesTableView.getSelectionModel().getSelectedItem();
            this.callback.handleEvent(IEvent.EVENT.REMOVED, ftm.fileMap);
            this.refresh();
        }
    }

    public void setCallback(ICallback<IEvent.EVENT, Object> callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(List<Map<String, String>> items) {
        if (this.isRefreshing.get()) {
            return;
        }
        BinferApplication.getInstance().startWaitCursor();
        this.isRefreshing.set(true);
        if (!items.isEmpty()) {
            this.filesList.clear();
        }
        try {
            for (Map<String, String> item : items) {
                try {
                    String spaceid = item.get(ISpace.SPACEID);
                    String fileid = item.get(IFile.FILEID);
                    this.filesList.add((Object)new FileTableModel(this.service.getFilesService().getFile(spaceid, fileid)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BinferApplication.getInstance().stopWaitCursor();
            this.isRefreshing.set(false);
        }
    }
}

