/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.report;

import com.binfer.base.service.IFile;
import com.binfer.base.service.ISpace;
import com.binfer.base.service.IUser;
import com.binfer.base.util.TimeUtil;
import com.binfer.core.service.IService;
import java.util.Date;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;

public class ReportModel {
    private SimpleStringProperty subject = new SimpleStringProperty();
    private SimpleStringProperty device = new SimpleStringProperty();
    private SimpleStringProperty file = new SimpleStringProperty();
    private SimpleStringProperty date = new SimpleStringProperty();
    private SimpleStringProperty ip = new SimpleStringProperty();
    private SimpleStringProperty speed = new SimpleStringProperty();
    Map<String, String> item;

    public ReportModel(Map<String, String> item, IService service) {
        this.item = item;
        this.setSubject(item.get(ISpace.SUBJECT));
        if (item.get(IFile.STATUS).equalsIgnoreCase(Byte.toString(IFile.FILE_STATUS_SENT))) {
            this.setDevice(service.getContactsService().getUserNameDeviceName(item.get(IUser.TOUSERID), item.get(IUser.TODEVICEID)));
            this.setIP(item.get(IUser.TOIP));
        } else {
            this.setDevice(service.getContactsService().getUserNameDeviceName(item.get(IUser.FROMUSERID), item.get(IUser.FROMDEVICEID)));
            this.setIP(item.get(IUser.FROMIP));
        }
        this.setFile(item.get(IFile.FILENAME));
        this.setDate(TimeUtil.getDayMonthYearTime(new Date(Long.parseLong(item.get(IUser.CREATED)))));
        this.setSpeed(item.get(IUser.BW));
    }

    public String getSubject() {
        return this.subject.get();
    }

    public void setSubject(String subject) {
        if (subject == null) {
            subject = "";
        }
        this.subject.set(subject);
    }

    public String getDevice() {
        return this.device.get();
    }

    public void setDevice(String name) {
        if (name == null) {
            name = "";
        }
        this.device.set(name);
    }

    public String getFile() {
        return this.file.get();
    }

    public void setFile(String file) {
        if (file == null) {
            file = "";
        }
        this.file.set(file);
    }

    public String getDate() {
        return this.date.get();
    }

    public void setDate(String date) {
        if (date == null) {
            date = "";
        }
        this.date.set(date);
    }

    public String getIP() {
        return this.ip.get();
    }

    public void setIP(String ip) {
        if (ip == null) {
            ip = "";
        }
        this.ip.set(ip);
    }

    public void setSpeed(String speed) {
        if (speed == null) {
            speed = "";
        }
        this.speed.set(speed);
    }

    public String getSpeed() {
        return this.speed.get();
    }
}

