/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.report;

import com.binfer.base.service.IFile;
import com.binfer.base.service.IUser;
import com.binfer.base.util.IPagedResult;
import com.binfer.base.util.Space;
import com.binfer.core.service.IService;
import com.binfer.desktop.shared.BinferApplication;
import com.binfer.desktop.shared.ui.report.ReportModel;
import com.binfer.desktop.shared.ui.report.ReportsFilter;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javafx.util.Callback;

public class ReportsController
implements Initializable {
    public static final String VIEW_SHARED_REPORTS = "/com/binfer/desktop/shared/ui/report/reports.fxml";
    private IPagedResult pr;
    private ObservableList<ReportModel> data = FXCollections.observableArrayList();
    private List<Map<String, String>> allDevices = new LinkedList<Map<String, String>>();
    private boolean displayAny;
    private boolean afterDateEnabled = true;
    private boolean beforeDateEnabled = true;
    private ObservableList<String> contactsComboBoxList;
    private ReportsFilter reportsFilter;
    private IService service;
    private Space space;
    private String spaceId = "";
    @FXML
    MenuButton saveButton;
    @FXML
    public BorderPane reportsBorderPane;
    @FXML
    private ComboBox<String> contactCombo;
    @FXML
    private DatePicker afterDatePicker;
    @FXML
    private DatePicker beforeDatePicker;
    @FXML
    private TableColumn<ReportModel, String> subjectColumn;
    @FXML
    private TableColumn<ReportModel, String> contactColumn;
    @FXML
    private TableColumn<ReportModel, String> fileColumn;
    @FXML
    private TableColumn<ReportModel, String> dateColumn;
    @FXML
    private TableColumn<ReportModel, String> ipColumn;
    @FXML
    private TableColumn<ReportModel, String> speedColumn;
    @FXML
    private ComboBox<String> typeCombo;
    @FXML
    private TableView<ReportModel> table;
    @FXML
    private ToolBar toolbar;
    @FXML
    private Label afterDateLabel;
    @FXML
    private Label beforeDateLabel;
    byte transferStatus;
    String userid = "%";
    String deviceid = null;
    Date before_date = null;
    Date after_date = null;

    public void initialize(URL url, ResourceBundle rb) {
        this.subjectColumn.setCellValueFactory((Callback)new PropertyValueFactory("subject"));
        this.contactColumn.setCellValueFactory((Callback)new PropertyValueFactory("device"));
        this.fileColumn.setCellValueFactory((Callback)new PropertyValueFactory("file"));
        this.dateColumn.setCellValueFactory((Callback)new PropertyValueFactory("date"));
        this.ipColumn.setCellValueFactory((Callback)new PropertyValueFactory("IP"));
        this.speedColumn.setCellValueFactory((Callback)new PropertyValueFactory("speed"));
        Calendar calendarBefore = Calendar.getInstance();
        calendarBefore.set(11, 23);
        calendarBefore.set(12, 59);
        calendarBefore.set(13, 0);
        this.beforeDatePicker.setValue((Object)LocalDate.of(calendarBefore.get(1), calendarBefore.get(2) + 1, calendarBefore.get(5)));
        Calendar calendarAfter = Calendar.getInstance();
        calendarAfter.set(10, 23);
        calendarAfter.set(12, 59);
        calendarAfter.set(13, 0);
        calendarAfter.add(4, -1);
        this.afterDatePicker.setValue((Object)LocalDate.of(calendarAfter.get(1), calendarAfter.get(2) + 1, calendarAfter.get(5)));
        ObservableList combo_data = FXCollections.observableArrayList((Object[])new String[]{"Received", "Sent"});
        this.typeCombo.setItems(combo_data);
        this.typeCombo.setValue((Object)"Received");
        this.contactsComboBoxList = this.contactCombo.getItems();
        this.table.setItems(this.data);
        this.saveButton.setText("SAVE");
    }

    public void setService(IService service) {
        this.service = service;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public void setFilterSpaceId(String spaceId) {
        this.spaceId = spaceId;
    }

    public void refresh(ReportsFilter reportsFilter) {
        this.reportsFilter = reportsFilter;
        this.typeCombo.setValue((Object)reportsFilter.getSelectedDirection());
        if (!reportsFilter.isShowDirection()) {
            this.toolbar.getItems().remove(this.typeCombo);
        }
        this.setDevicesComboBox(this.service.getContactsService().getDevices(true), this.reportsFilter.isShowAnyDevice());
        if (!reportsFilter.isShowDevices()) {
            this.toolbar.getItems().remove(this.contactCombo);
        }
        this.refresh();
    }

    public void refresh() {
        BinferApplication.getInstance().startWaitCursor();
        try {
            this._refresh();
        }
        catch (Exception exception) {
        }
        finally {
            BinferApplication.getInstance().stopWaitCursor();
        }
    }

    private void _refresh() {
        this.data.clear();
        this.transferStatus = this.getTransferStatus();
        if (((String)this.contactCombo.getValue()).equalsIgnoreCase("Any") || !this.contactCombo.isVisible()) {
            this.userid = "%";
            this.deviceid = "%";
        } else {
            int i = this.contactCombo.getSelectionModel().getSelectedIndex();
            if (this.displayAny) {
                --i;
            }
            Map<String, String> dev = this.allDevices.get(i);
            this.userid = dev.get(IUser.USERID);
            this.deviceid = dev.get(IUser.DEVICEID);
        }
        if (this.beforeDateEnabled) {
            Calendar before_cal = Calendar.getInstance();
            LocalDate before_localdate = (LocalDate)this.beforeDatePicker.getValue();
            before_cal.set(1, before_localdate.getYear());
            before_cal.set(2, before_localdate.getMonthValue() - 1);
            before_cal.set(5, before_localdate.getDayOfMonth());
            this.before_date = before_cal.getTime();
        }
        if (this.afterDateEnabled) {
            LocalDate after_localdate = (LocalDate)this.afterDatePicker.getValue();
            Calendar after_cal = Calendar.getInstance();
            after_cal.set(1, after_localdate.getYear());
            after_cal.set(2, after_localdate.getMonthValue() - 1);
            after_cal.set(5, after_localdate.getDayOfMonth());
            this.after_date = after_cal.getTime();
        }
        try {
            this.pr = this.service.getFilesService().getXferLogs(this.spaceId, this.userid, this.deviceid, this.after_date, this.before_date, this.transferStatus, IUser.CREATED, false, 20);
            List reports = this.pr.next();
            this.updateTable(reports);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateTable(List<Map<String, String>> items) {
        this.data.clear();
        for (Map<String, String> item : items) {
            this.data.add((Object)new ReportModel(item, this.service));
        }
    }

    public void setDevicesComboBox(List<Map<String, String>> devices, boolean displayAny) {
        if (devices == null || devices.isEmpty()) {
            this.contactCombo.setVisible(false);
            this.toolbar.getItems().remove(this.contactCombo);
        } else {
            this.displayAny = displayAny;
            this.allDevices.clear();
            try {
                this.contactCombo.getItems().clear();
                this.contactsComboBoxList.clear();
                HashSet<String> added = new HashSet<String>();
                if (displayAny) {
                    this.contactsComboBoxList.add((Object)"Any");
                }
                for (Map<String, String> device : devices) {
                    try {
                        String key = device.get(IUser.USERID);
                        if (added.contains(key)) continue;
                        added.add(key);
                        String uname = "";
                        String sys_uname = this.service.getContactsService().getDeviceProperty(device.get(IUser.USERID), device.get(IUser.DEVICEID), IUser.SYS_UNAME);
                        if (sys_uname != null && !sys_uname.equalsIgnoreCase("null") && !sys_uname.isEmpty()) {
                            uname = " (" + sys_uname + ")";
                        }
                        this.contactsComboBoxList.add((Object)(this.service.getContactsService().getFullName(device.get(IUser.USERID)) + uname));
                        this.allDevices.add(device);
                    }
                    catch (Exception exception) {}
                }
                try {
                    this.contactCombo.setValue(this.contactsComboBoxList.get(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void handleActionComboClicked(ActionEvent event) {
        this.refresh();
    }

    @FXML
    private void handleContactComboClicked(ActionEvent event) {
        this.refresh();
    }

    private void handleAfterCheckboxClicked(ActionEvent event) {
        this.refresh();
    }

    @FXML
    private void handleAfterDatePickerClicked(ActionEvent event) {
        this.refresh();
    }

    private void handleBeforeCheckboxClicked(ActionEvent event) {
        this.refresh();
    }

    @FXML
    public void handleBeforeDatePickerClicked(ActionEvent event) {
        this.refresh();
    }

    public void handleSaveButtonClicked(MouseEvent event) {
        this.refresh();
    }

    public void handleSearchButtonClicked(MouseEvent event) {
        this.refresh();
    }

    public void removeAfterDateFilter() {
        this.afterDateEnabled = false;
        this.toolbar.getItems().remove((Object)this.afterDateLabel);
        this.toolbar.getItems().remove((Object)this.afterDatePicker);
    }

    public void removeBeforeDateFilter() {
        this.beforeDateEnabled = false;
        this.toolbar.getItems().remove((Object)this.beforeDateLabel);
        this.toolbar.getItems().remove((Object)this.beforeDatePicker);
    }

    public void removeSubjectColumn() {
        this.table.getColumns().remove(this.subjectColumn);
    }

    private byte getTransferStatus() {
        byte transferType = IFile.FILE_STATUS_RECEIVED;
        switch ((String)this.typeCombo.getValue()) {
            case "Received": {
                transferType = IFile.FILE_STATUS_RECEIVED;
                break;
            }
            case "Sent": {
                transferType = IFile.FILE_STATUS_SENT;
                break;
            }
            default: {
                transferType = IFile.FILE_STATUS_RECEIVED;
            }
        }
        return transferType;
    }

    @Deprecated
    public void removeTypeFilter() {
        this.toolbar.getItems().remove(this.typeCombo);
    }

    @Deprecated
    public void setFilterSent() {
        this.typeCombo.setValue((Object)"Sent");
    }

    @Deprecated
    public void setFilterReceived() {
        this.typeCombo.setValue((Object)"Received");
    }

    @FXML
    private void handleSaveClicked(ActionEvent event) {
        try {
            MenuItem item = (MenuItem)MenuItem.class.cast(event.getSource());
            DirectoryChooser directoryChooser = new DirectoryChooser();
            File folder = directoryChooser.showDialog((Window)BinferApplication.getInstance().getStage());
            File f = null;
            if (item.getText().equalsIgnoreCase("HTML")) {
                f = this.service.getReportService().saveReportAsHTML(folder, this.transferStatus, this.spaceId, this.userid, this.after_date, this.before_date);
            } else if (item.getText().equalsIgnoreCase("CSV")) {
                f = this.service.getReportService().saveReportAsCSV(folder, this.transferStatus, this.spaceId, this.userid, this.after_date, this.before_date);
            } else if (item.getText().equalsIgnoreCase("HTML-CHECKSUM")) {
                f = this.service.getReportService().saveReportAsHTMLWithChecksum(folder, this.transferStatus, this.spaceId, this.userid, this.after_date, this.before_date);
            } else if (item.getText().equalsIgnoreCase("CSV-CHECKSUM")) {
                f = this.service.getReportService().saveReportAsCSVWithChecksum(folder, this.transferStatus, this.spaceId, this.userid, this.after_date, this.before_date);
            }
            BinferApplication.getInstance().showPopup("Report saved: " + f.getAbsolutePath());
            BinferApplication.getInstance().openURI(f.toURI());
        }
        catch (Exception e) {
            BinferApplication.getInstance().showError("Failed to save because " + e.getMessage());
        }
    }

    @FXML
    public void handleSearchButtonClicked(ActionEvent event) {
        this.refresh();
    }

    @FXML
    public void handlePrevButtonClicked(ActionEvent event) {
        try {
            this.updateTable(this.pr.previous());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    public void handleNextButtonClicked(ActionEvent event) {
        try {
            this.updateTable(this.pr.previous());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

