/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.setup;

import com.binfer.base.service.AuthenticationInfo;
import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.ILicense;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.service.NetworkService;
import com.binfer.desktop.shared.BinferApplication;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;

public class LoginController
implements Initializable {
    @FXML
    private Button loginNextButton;
    @FXML
    private BorderPane loginPane;
    @FXML
    private TextField loginIdTextField;
    @FXML
    private PasswordField passwordTextField;
    @FXML
    private PasswordField accessCodeTextField;
    @FXML
    private TextField accountIdTextField;
    @FXML
    private TextField accountIdResultTextField;
    @FXML
    private TextField accessCodeResultTextField;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            String userId = BinferProperties.getProperty(IUser.USERID);
            if (userId != null && !userId.isEmpty()) {
                this.loginIdTextField.setText(userId);
            }
        }
        catch (Exception userId) {
            // empty catch block
        }
        try {
            String password = BinferProperties.getProperty(IUser.PASSWORD);
            if (password != null && !password.isEmpty()) {
                this.passwordTextField.setText(password);
            }
        }
        catch (Exception password) {
            // empty catch block
        }
        boolean isAutoLogin = BinferProperties.getBooleanProperty("ISINITED", false);
        if (isAutoLogin) {
            this.login();
        }
    }

    @FXML
    private void handleSignupClicked(ActionEvent event) {
        BinferApplication.getInstance().setView("/com/binfer/desktop/shared/ui/signup/signup.fxml");
    }

    @FXML
    private synchronized void handleNextClicked(ActionEvent event) {
        this.login();
    }

    private void login() {
        try {
            this.loginNextButton.setDisable(true);
            BinferApplication.getInstance().startWaitCursor();
            AuthenticationInfo ai = null;
            if (this.loginIdTextField.getText() == null || this.loginIdTextField.getText().trim().isEmpty()) {
                BinferApplication.getInstance().showError("Login Id is required.");
                return;
            }
            if (this.passwordTextField.getText() == null || this.passwordTextField.getText().trim().isEmpty()) {
                BinferApplication.getInstance().showError("Password is required.");
                return;
            }
            ai = NetworkService.authenticateUser(this.loginIdTextField.getText(), this.passwordTextField.getText(), ILicense.PRODUCT.valueOf(BinferProperties.getProperty(ILicense.PROPS.PRODUCT.name())));
            BinferApplication.setCacheObject("AI", ai);
            if (!ai.isSuccess()) {
                throw new Exception("Invalid Login Id or Password. If you do not have an account then please signup.");
            }
            if (!ai.canAddDevice()) {
                throw new Exception("No more device licenses available. Contact support: https://sync.binfer.com/support/");
            }
            boolean isInited = BinferProperties.getBooleanProperty("ISINITED", false);
            if (isInited) {
                BinferApplication.getInstance().login();
            } else {
                BinferApplication.getInstance().setView("/com/binfer/desktop/shared/ui/setup/options.fxml");
            }
        }
        catch (Exception e) {
            LogService.log("EXPN. failed to authenticate: " + e.getMessage(), Level.SEVERE);
            e.printStackTrace();
            BinferApplication.getInstance().showError(e.getMessage());
        }
        finally {
            this.loginNextButton.setDisable(false);
            BinferApplication.getInstance().stopWaitCursor();
        }
    }

    private void handleCheckboxClicked(ActionEvent event) {
    }
}

