/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.setup;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.INetwork;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.IUser;
import com.binfer.base.util.StringUtil;
import com.binfer.desktop.shared.BinferApplication;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;

public class OptionsController
implements Initializable {
    final DirectoryChooser directoryChooser = new DirectoryChooser();
    File folderselected;
    @FXML
    private TextField portTextField;
    @FXML
    private TextField dataFolderTextField;
    @FXML
    private TextField deviceNameTextField;
    @FXML
    private BorderPane optionsPane;

    public void initialize(URL url, ResourceBundle rb) {
        try {
            this.portTextField.setText(Integer.toString(BinferProperties.getIntegerProperty(INetwork.HTTPPORT, 1212)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.deviceNameTextField.setText(BinferProperties.getProperty(IUser.DEVICENAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dataFolderTextField.setText(BinferProperties.getProperty(IPreferences.DOWNLOADPATH));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    private void handleNextClicked(ActionEvent event) {
        try {
            String folder = this.dataFolderTextField.getText();
            if (folder == null || folder.isEmpty()) {
                throw new Exception("Select a valid data folder.");
            }
            BinferProperties.setProperty(IPreferences.DOWNLOADPATH, folder);
            int port = BinferProperties.getIntegerProperty(INetwork.HTTPPORT, 1212);
            if (port <= 0 || port >= 49152) {
                throw new Exception("Select a valid port.");
            }
            BinferProperties.setProperty(INetwork.HTTPPORT, Integer.toString(port));
            String deviceName = StringUtil.removeInvalidChars(this.deviceNameTextField.getText());
            this.deviceNameTextField.setText(deviceName);
            if (deviceName == null || deviceName.isEmpty()) {
                throw new Exception("Device name is invalid.");
            }
            BinferProperties.setProperty(IUser.DEVICENAME, deviceName);
            BinferApplication.getInstance().setView("/com/binfer/desktop/shared/ui/setup/setupsummary.fxml");
        }
        catch (Exception e) {
            BinferApplication.getInstance().showError(e.getMessage());
        }
    }

    @FXML
    private void handlePrevClicked(ActionEvent event) {
        BinferApplication.getInstance().setView("/com/binfer/desktop/shared/ui/setup/login.fxml");
    }

    @FXML
    private void handleFolderButtonClicked(ActionEvent event) {
        this.folderselected = this.directoryChooser.showDialog((Window)BinferApplication.getInstance().getStage());
        this.dataFolderTextField.setText(this.folderselected.getAbsolutePath());
        BinferProperties.setProperty(IPreferences.DOWNLOADPATH, this.folderselected.getAbsolutePath());
    }
}

