/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.setup;

import com.binfer.base.service.AuthenticationInfo;
import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.INetwork;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.IStrings;
import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.service.NetworkService;
import com.binfer.base.xml.XMLObject;
import com.binfer.desktop.shared.BinferApplication;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;

public class SetupSummaryController
implements Initializable {
    @FXML
    private TextField deviceNameTextField;
    @FXML
    private TextField dataFolderTextField;
    @FXML
    private TextField portTextField;
    @FXML
    private BorderPane summaryPane;
    @FXML
    private TextField systemFolderTextField;
    @FXML
    private Button finishButton;
    @FXML
    private Button previousButton;
    private final AtomicBoolean isProcessing = new AtomicBoolean(false);

    public void initialize(URL url, ResourceBundle rb) {
        this.deviceNameTextField.setText(BinferProperties.getProperty(IUser.DEVICENAME));
        this.deviceNameTextField.setEditable(false);
        this.dataFolderTextField.setText(BinferProperties.getProperty(IPreferences.DOWNLOADPATH));
        this.dataFolderTextField.setEditable(false);
        this.systemFolderTextField.setText(BinferProperties.getProperty(IPreferences.SYSTEMPATH));
        this.systemFolderTextField.setEditable(false);
        this.portTextField.setText(BinferProperties.getProperty(INetwork.HTTPPORT));
        this.portTextField.setEditable(false);
        this.deviceNameTextField.setEditable(false);
    }

    @FXML
    private void handlePrevClicked(ActionEvent event) {
        BinferApplication.getInstance().setView("/com/binfer/desktop/shared/ui/setup/options.fxml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private synchronized void handleNextClicked(ActionEvent event) {
        if (this.isProcessing.get()) {
            return;
        }
        this.isProcessing.set(true);
        this.finishButton.setDisable(true);
        this.previousButton.setDisable(true);
        try {
            BinferApplication.getInstance().startWaitCursor();
            AuthenticationInfo ai = (AuthenticationInfo)BinferApplication.getCacheObject("AI");
            if (!ai.canAddDevice()) {
                throw new Exception("No more device licenses available. Contact support: https://sync.binfer.com/support/");
            }
            String pcFileURL = NetworkService.addDeviceOnServer(ai.getAccountId(), ai.getEmailId(), BinferProperties.getProperty(IUser.DEVICENAME));
            if (!pcFileURL.startsWith("http")) {
                XMLObject xo = new XMLObject(pcFileURL);
                String error = xo.getNodeText("/details");
                throw new Exception(error);
            }
            BinferProperties.setProperty("PCFILE", pcFileURL);
            BinferProperties.setProperty("ISINITED", IStrings.STR_TRUE);
            BinferProperties.setProperty(IUser.ACCOUNTID, Long.toString(ai.getAccountId()));
            BinferProperties.setProperty(IUser.DEVICEID, NetworkService.getDeviceIdFromUserId(Long.toString(ai.getAccountId()), BinferProperties.getProperty(IUser.DEVICENAME)));
            BinferProperties.save();
            BinferApplication.getInstance().login();
        }
        catch (Exception e) {
            e.printStackTrace();
            LogService.log("EXPN.Failed to add device because " + e.getMessage() + "\n>>" + BinferProperties.getProperties(), Level.SEVERE);
            BinferApplication.getInstance().showError(e.getMessage());
        }
        finally {
            this.isProcessing.set(false);
            BinferApplication.getInstance().stopWaitCursor();
        }
    }
}

