/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.signup;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.IBinfer;
import com.binfer.base.service.ILicense;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.IUser;
import com.binfer.base.service.NetworkService;
import com.binfer.desktop.shared.BinferApplication;
import com.binfer.desktop.shared.ui.IView;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;

public class InfoViewController
implements Initializable,
IView {
    Map<String, String> data = new HashMap<String, String>();
    @FXML
    private TextField firstNameTextField;
    @FXML
    private TextField lastNameTextField;
    @FXML
    private PasswordField passwordTextField;
    @FXML
    private PasswordField passwordConfirmTextField;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void onCreate(Object o) {
        try {
            this.data.putAll((Map)Map.class.cast(o));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.firstNameTextField.setText(this.data.get(IUser.FNAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.lastNameTextField.setText(this.data.get(IUser.LNAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.passwordTextField.setText(this.data.get(IUser.PASSWORD));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onDestroy(Object data) {
    }

    @Override
    public void refresh(Object data) {
    }

    private void createAccount() {
        try {
            if (this.firstNameTextField.getText() == null || this.firstNameTextField.getText().isEmpty()) {
                throw new Exception("Valid first name is required");
            }
            if (this.lastNameTextField.getText() == null || this.lastNameTextField.getText().isEmpty()) {
                throw new Exception("Valid last name is required");
            }
            if (this.passwordTextField.getText() == null || this.passwordTextField.getText().isEmpty() || this.passwordConfirmTextField.getText() == null || this.passwordConfirmTextField.getText().isEmpty()) {
                throw new Exception("Valid password is required");
            }
            if (!this.passwordTextField.getText().equalsIgnoreCase(this.passwordConfirmTextField.getText())) {
                throw new Exception("Passwords don't match");
            }
            this.data.put(IUser.FNAME, this.firstNameTextField.getText());
            this.data.put(IUser.LNAME, this.lastNameTextField.getText());
            this.data.put(IUser.PASSWORD, this.passwordTextField.getText());
            NetworkService.createAccount(this.data.get(IUser.USERID), this.data.get(IUser.PASSWORD), this.data.get(IUser.FNAME), this.data.get(IUser.LNAME), "", IBinfer.INSTALL_TYPE.valueOf(BinferProperties.getProperty(IPreferences.INSTALLTYPE)), IBinfer.CLIENT_TYPE.valueOf(BinferProperties.getProperty(IPreferences.CLIENTTYPE)), ILicense.PRODUCT.valueOf(BinferProperties.getProperty(ILicense.PROPS.PRODUCT.name())));
            BinferApplication.getInstance().setView("/com/binfer/desktop/shared/ui/setup/login.fxml");
            BinferApplication.getInstance().showPopup("Account created. Login to continue.");
        }
        catch (Exception e) {
            BinferApplication.getInstance().showError(e.getMessage());
        }
    }

    @FXML
    private void handlePreviousClicked(ActionEvent event) {
    }

    @FXML
    private void handleNextClicked(ActionEvent event) {
        this.createAccount();
    }
}

