/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.desktop.shared.ui.signup;

import com.binfer.base.service.IUser;
import com.binfer.base.service.LogService;
import com.binfer.base.service.NetworkService;
import com.binfer.desktop.shared.BinferApplication;
import com.binfer.desktop.shared.ui.IView;
import com.binfer.mail.DisposableEmail;
import com.binfer.mail.MailSender;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;

public class SignupController
implements Initializable,
IView {
    int retryDelay = 0;
    Object waiter = new Object();
    Map<String, String> data = new HashMap<String, String>();
    @FXML
    private TextField emailTextField;
    @FXML
    private Button signupNextButton;

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void onCreate(Object o) {
        try {
            this.data.putAll((Map)Map.class.cast(o));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.emailTextField.setText(this.data.get(IUser.USERID));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onDestroy(Object data) {
    }

    @Override
    public void refresh(Object data) {
    }

    @FXML
    private void handlePrevClicked(ActionEvent event) {
        BinferApplication.getInstance().setView("/com/binfer/desktop/shared/ui/setup/login.fxml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private synchronized void handleNextClicked(ActionEvent event) {
        try {
            this.signupNextButton.setDisable(true);
            BinferApplication.getInstance().startWaitCursor();
            String userId = this.emailTextField.getText();
            if (!MailSender.isValidEMailDomain((String)userId) || DisposableEmail.isDisposable((String)userId)) {
                LogService.log("Domain blocked:" + userId, Level.WARNING);
                this.retryDelay += 5000;
                Object object = this.waiter;
                synchronized (object) {
                    this.waiter.wait(this.retryDelay);
                }
                throw new Exception("Email domain is not allowed. Please choose another.");
            }
            String verificationCode = NetworkService.createVerificationCode(userId);
            if (verificationCode == null || verificationCode.isEmpty()) {
                throw new Exception("Unable to obtain verification code. Please contact support.");
            }
            BinferApplication.getInstance().stopWaitCursor();
            String code = BinferApplication.getInstance().showInputDialog("Verification Code", "Please enter the code sent to " + userId);
            if (!code.equalsIgnoreCase(verificationCode)) {
                throw new Exception("Incorrect validtion code entered");
            }
            this.data.put(IUser.USERID, userId);
            BinferApplication.getInstance().setView("/com/binfer/desktop/shared/ui/signup/infoview.fxml", this.data);
        }
        catch (Exception e) {
            BinferApplication.getInstance().showError(e.getMessage());
        }
        finally {
            this.signupNextButton.setDisable(false);
        }
    }
}

