/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.GestureSupport;
import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MouseInputSynthesizer;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.TouchPipeline;
import com.sun.glass.ui.monocle.TouchState;
import java.security.AccessController;

class TouchInput {
    private final int touchRadius = AccessController.doPrivileged(() -> Integer.getInteger("monocle.input.touchRadius", 20));
    private static TouchInput instance = new TouchInput();
    private TouchPipeline basePipeline;
    private TouchState state = new TouchState();
    private final GestureSupport gestures = new GestureSupport(false);
    private final TouchInputSupport touches = new TouchInputSupport(this.gestures.createTouchCountListener(), false);

    static TouchInput getInstance() {
        return instance;
    }

    private TouchInput() {
    }

    TouchPipeline getBasePipeline() {
        if (this.basePipeline == null) {
            this.basePipeline = new TouchPipeline();
            String[] stringArray = AccessController.doPrivileged(() -> System.getProperty("monocle.input.touchFilters", "SmallMove")).split(",");
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.basePipeline.addNamedFilter(string.trim());
                }
            }
        }
        return this.basePipeline;
    }

    void getState(TouchState touchState) {
        this.state.copyTo(touchState);
    }

    void setState(TouchState touchState) {
        View view;
        if (MonocleSettings.settings.traceEvents) {
            MonocleTrace.traceEvent("Set %s", touchState);
        }
        touchState.sortPointsByID();
        touchState.assignPrimaryID();
        MonocleWindow monocleWindow = this.state.getWindow(false, null);
        boolean bl = this.state.getPointCount() == 0;
        MonocleWindow monocleWindow2 = touchState.getWindow(bl, monocleWindow);
        View view2 = monocleWindow == null ? null : monocleWindow.getView();
        View view3 = view = monocleWindow2 == null ? null : monocleWindow2.getView();
        if (!touchState.equalsSorted(this.state)) {
            if (view != view2) {
                this.postTouchEvent(this.state, 813);
                this.postTouchEvent(touchState, 811);
            } else if (view != null) {
                this.postTouchEvent(monocleWindow2, view, touchState);
            }
            MouseInputSynthesizer.getInstance().setState(touchState);
        }
        touchState.copyTo(this.state);
        touchState.clearWindow();
    }

    private void dispatchPoint(Window window, View view, int n, int n2, int n3, int n4) {
        this.touches.notifyNextTouchEvent(view, n, n2, n3 - window.getX(), n4 - window.getY(), n3, n4);
    }

    private void postPoints(Window window, View view, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        RunnableProcessor.runLater(() -> {
            this.touches.notifyBeginTouchEvent(view, 0, true, nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                this.dispatchPoint(window, view, nArray[i], nArray2[i], nArray3[i], nArray4[i]);
            }
            this.touches.notifyEndTouchEvent(view);
        });
    }

    private void postPoint(Window window, View view, int n, TouchState.Point point) {
        int n2 = point.id;
        int n3 = point.x;
        int n4 = point.y;
        RunnableProcessor.runLater(() -> {
            this.touches.notifyBeginTouchEvent(view, 0, true, 1);
            this.dispatchPoint(window, view, n, n2, n3, n4);
            this.touches.notifyEndTouchEvent(view);
        });
    }

    private void postNoPoints(View view) {
        RunnableProcessor.runLater(() -> {
            this.touches.notifyBeginTouchEvent(view, 0, true, 0);
            this.touches.notifyEndTouchEvent(view);
        });
    }

    private void postTouchEvent(TouchState touchState, int n) {
        View view;
        MonocleWindow monocleWindow = touchState.getWindow(false, null);
        View view2 = view = monocleWindow == null ? null : monocleWindow.getView();
        if (view != null) {
            switch (touchState.getPointCount()) {
                case 0: {
                    this.postNoPoints(view);
                    break;
                }
                case 1: {
                    this.postPoint(monocleWindow, view, n, touchState.getPoint(0));
                    break;
                }
                default: {
                    int n2 = touchState.getPointCount();
                    int[] nArray = new int[n2];
                    int[] nArray2 = new int[n2];
                    int[] nArray3 = new int[n2];
                    int[] nArray4 = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        nArray[i] = n;
                        TouchState.Point point = touchState.getPoint(i);
                        nArray2[i] = point.id;
                        nArray3[i] = point.x;
                        nArray4[i] = point.y;
                    }
                    this.postPoints(monocleWindow, view, nArray, nArray2, nArray3, nArray4);
                }
            }
        }
    }

    private void postTouchEvent(MonocleWindow monocleWindow, View view, TouchState touchState) {
        int n = this.countEvents(touchState);
        switch (n) {
            case 0: {
                this.postNoPoints(view);
                break;
            }
            case 1: {
                if (this.state.getPointCount() == 1) {
                    TouchState.Point point = this.state.getPoint(0);
                    TouchState.Point point2 = touchState.getPointForID(point.id);
                    if (point2 != null) {
                        if (point2.x == point.x && point2.y == point.y) {
                            this.postPoint(monocleWindow, view, 814, point2);
                            break;
                        }
                        this.postPoint(monocleWindow, view, 812, point2);
                        break;
                    }
                    this.postPoint(monocleWindow, view, 813, point);
                    break;
                }
                this.postPoint(monocleWindow, view, 811, touchState.getPoint(0));
                break;
            }
            default: {
                TouchState.Point point;
                int n2;
                int[] nArray = new int[n];
                int[] nArray2 = new int[n];
                int[] nArray3 = new int[n];
                int[] nArray4 = new int[n];
                for (n2 = 0; n2 < this.state.getPointCount(); ++n2) {
                    TouchState.Point point3 = this.state.getPoint(n2);
                    point = touchState.getPointForID(point3.id);
                    if (point != null) {
                        nArray2[n2] = point.id;
                        nArray3[n2] = point.x;
                        nArray4[n2] = point.y;
                        if (point.x == point3.x && point.y == point3.y) {
                            nArray[n2] = 814;
                            continue;
                        }
                        nArray[n2] = 812;
                        continue;
                    }
                    nArray[n2] = 813;
                    nArray2[n2] = point3.id;
                    nArray3[n2] = point3.x;
                    nArray4[n2] = point3.y;
                }
                int n3 = this.state.getPointCount();
                for (n2 = 0; n2 < touchState.getPointCount(); ++n2) {
                    point = touchState.getPoint(n2);
                    TouchState.Point point4 = this.state.getPointForID(point.id);
                    if (point4 != null) continue;
                    nArray[n3] = 811;
                    nArray2[n3] = point.id;
                    nArray3[n3] = point.x;
                    nArray4[n3] = point.y;
                    ++n3;
                }
                this.postPoints(monocleWindow, view, nArray, nArray2, nArray3, nArray4);
            }
        }
    }

    private int countEvents(TouchState touchState) {
        int n = this.state.getPointCount();
        for (int i = 0; i < touchState.getPointCount(); ++i) {
            TouchState.Point point = touchState.getPoint(i);
            TouchState.Point point2 = this.state.getPointForID(point.id);
            if (point2 != null) continue;
            ++n;
        }
        return n;
    }

    int getTouchRadius() {
        return this.touchRadius;
    }
}

