/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.IDN;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class PublicSuffixes {
    private static final Logger logger = Logger.getLogger(PublicSuffixes.class.getName());
    private static final Map<String, Rules> rulesCache = new ConcurrentHashMap<String, Rules>();
    private static final String psResourceName = "public_suffix_list.dat";
    private static final boolean pslDataExists = AccessController.doPrivileged(() -> {
        if (null == Rules.getPubSuffixStream()) {
            logger.warning("Resource not found: public_suffix_list.dat");
            return false;
        }
        return true;
    });

    private PublicSuffixes() {
        throw new AssertionError();
    }

    static boolean isPslDataExists() {
        return pslDataExists;
    }

    static boolean isPublicSuffix(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!pslDataExists) {
            return false;
        }
        Rules rules = Rules.getRules(string);
        return rules == null ? false : rules.match(string);
    }

    private static String toLogString(Map<String, Rule> map) {
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Rule> entry : map.entrySet()) {
            stringBuilder.append(String.format("%n    ", new Object[0]));
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append((Object)entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static class Rules {
        private final Map<String, Rule> rules = new HashMap<String, Rule>();

        private Rules(InputStream inputStream) throws IOException {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            int n = bufferedReader.read();
            while (n != -1 && (string = bufferedReader.readLine()) != null) {
                Rule rule;
                if (string.startsWith("!")) {
                    string = string.substring(1);
                    rule = Rule.EXCEPTION_RULE;
                } else if (string.startsWith("*.")) {
                    string = string.substring(2);
                    rule = Rule.WILDCARD_RULE;
                } else {
                    rule = Rule.SIMPLE_RULE;
                }
                try {
                    string = IDN.toASCII(string, 1);
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, String.format("Error parsing rule: [%s]", string), exception);
                    continue;
                }
                this.rules.put(string, rule);
                n = bufferedReader.read();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "rules: {0}", PublicSuffixes.toLogString(this.rules));
            }
        }

        static Rules getRules(String string) {
            String string3 = Rules.getTopLevelDomain(string);
            if (string3.isEmpty()) {
                return null;
            }
            return rulesCache.computeIfAbsent(string3, string2 -> Rules.createRules(string3));
        }

        private static String getTopLevelDomain(String string) {
            int n = (string = IDN.toUnicode(string, 1)).lastIndexOf(46);
            if (n == -1) {
                return string;
            }
            return string.substring(n + 1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Rules createRules(String string) {
            try (InputStream inputStream = Rules.getPubSuffixStream();){
                if (inputStream == null) {
                    Rules rules = null;
                    return rules;
                }
                ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    if (zipEntry.getName().equals(string)) {
                        Rules rules = new Rules(zipInputStream);
                        return rules;
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
                return null;
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Unexpected error", iOException);
            }
            return null;
        }

        private static InputStream getPubSuffixStream() {
            return AccessController.doPrivileged(() -> {
                InputStream inputStream = PublicSuffixes.class.getResourceAsStream(PublicSuffixes.psResourceName);
                if (inputStream == null) {
                    logger.log(Level.WARNING, "Resource not found: public_suffix_list.dat");
                }
                return inputStream;
            });
        }

        boolean match(String string) {
            String string2;
            Rule rule = this.rules.get(string);
            if (rule == Rule.EXCEPTION_RULE) {
                return false;
            }
            if (rule == Rule.SIMPLE_RULE || rule == Rule.WILDCARD_RULE) {
                return true;
            }
            int n = string.indexOf(46) + 1;
            if (n == 0) {
                n = string.length();
            }
            return this.rules.get(string2 = string.substring(n)) == Rule.WILDCARD_RULE;
        }
    }

    private static enum Rule {
        SIMPLE_RULE,
        WILDCARD_RULE,
        EXCEPTION_RULE;

    }
}

