/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.providers.h2;

import com.binfer.base.service.BinferProperties;
import com.binfer.base.service.DownloadService;
import com.binfer.base.service.IDatabaseService;
import com.binfer.base.service.IEnc;
import com.binfer.base.service.IPreferences;
import com.binfer.base.service.LogService;
import com.binfer.providers.h2.IConnectionPool;
import com.binfer.providers.h2.MiniConnectionPoolManager;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.h2.util.Profiler;

public class H2Provider
implements IDatabaseService {
    private String dbOptions = ";MV_STORE=FALSE;MVCC=TRUE;TRACE_LEVEL_SYSTEM_OUT=0;TRACE_LEVEL_FILE=0;AUTO_RECONNECT=TRUE;CIPHER=AES;DB_CLOSE_ON_EXIT=TRUE";
    private AtomicBoolean databaseOpen = new AtomicBoolean(true);
    IConnectionPool poolMgr;
    private File dbFile;
    String dbfilename = "binfer5";
    String DB_URL;
    private boolean isInited = false;
    int maxdbconnections = 4;
    int sqlCache = 131072;
    Profiler profiler;
    int queryCount = 0;
    int executeCount = 0;
    int k = 0;

    public H2Provider() {
    }

    public H2Provider(String dbfilename) {
        this.dbfilename = dbfilename;
    }

    public synchronized void init(String userid, String password) throws Exception {
        if (this.isInited) {
            return;
        }
        this.isInited = true;
        this.dbFile = new File(DownloadService.getSystemDirectory(), userid + "/" + this.dbfilename);
        Class.forName("org.h2.Driver");
        try {
            this.maxdbconnections = Integer.parseInt(BinferProperties.getProperty((String)IPreferences.DB_CONNECTIONS_MAX));
        }
        catch (Exception e) {
            this.maxdbconnections = 4;
        }
        try {
            this.sqlCache = Integer.parseInt(BinferProperties.getProperty((String)IPreferences.DB_CACHE));
        }
        catch (Exception e) {
            this.sqlCache = 131072;
        }
        this.DB_URL = "jdbc:h2:file://" + this.dbFile.getCanonicalPath() + this.dbOptions;
        this.poolMgr = new MiniConnectionPoolManager(this.DB_URL, userid, IEnc.DB_P1 + " " + IEnc.DB_P2, this.maxdbconnections, 60);
        this.setCacheSize();
        LogService.log((String)("DB inited with max connections:" + this.maxdbconnections + " and cache:" + this.sqlCache), (Level)Level.WARNING);
    }

    public Connection getConnection() throws Exception {
        return this.poolMgr.getConnection();
    }

    private void setCacheSize() {
        try {
            this.sqlExecute("SET CACHE_SIZE " + this.sqlCache);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.poolMgr.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.poolMgr.getDataSource().getConnection().createStatement().execute("SHUTDOWN");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.databaseOpen.set(false);
    }

    public void sqlExecute(String sql) throws Exception {
        if (!this.databaseOpen.get()) {
            throw new Exception("database is closed");
        }
        long st1 = System.currentTimeMillis();
        long st2 = 0L;
        int j = this.queryCount++;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            st2 = System.currentTimeMillis();
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            stmt.execute(sql);
        }
        catch (Throwable e) {
            String err = e.getMessage();
            if (err.contains("already exists")) {
                LogService.log((String)("EXPN.execute:" + sql + ", err:" + e.getMessage()), (Level)Level.WARNING);
            }
            throw new Exception("Bad SQL: " + sql, e);
        }
        finally {
            long st3 = System.currentTimeMillis();
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
            long l = st3 - st1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sqlExecute(List<String> sql) throws Exception {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            for (String query : sql) {
                stmt.addBatch(query);
            }
            stmt.executeBatch();
        }
        catch (Throwable throwable) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> sqlQuery(String sql) throws Exception {
        if (!this.databaseOpen.get()) {
            throw new Exception("database is closed");
        }
        long st1 = System.currentTimeMillis();
        int j = this.queryCount++;
        StringBuilder sb = new StringBuilder();
        Statement stmt = null;
        Connection conn = this.getConnection();
        long st2 = System.currentTimeMillis();
        LinkedList<Map<String, String>> results = new LinkedList<Map<String, String>>();
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData meta = rs.getMetaData();
            int columncount = meta.getColumnCount();
            while (rs.next()) {
                try {
                    LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                    results.add(row);
                    for (int i = 1; i <= columncount; ++i) {
                        try {
                            String name = meta.getColumnName(i);
                            row.put(name, rs.getString(name));
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Throwable e) {
            if (!e.getMessage().contains(" not found")) {
                sb.append("ERR:").append(e.getMessage());
                sb.append(", ").append(sql).append("\n");
                throw new Exception(e);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception rs) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception rs) {}
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sqlDeleteDuplicateRows(String table, String column, String whereCol, String whereVal, String orderBy, boolean asc) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement(1005, 1008);
            String sql = "SELECT t1.* FROM " + table + " AS t1 INNER JOIN " + table + " AS t2 ON t1." + column + "=t2." + column + " where t1.TYPE=8 order by t1." + orderBy + " " + (asc ? "asc" : "desc");
            ResultSet rs = stmt.executeQuery(sql);
            HashSet<String> firstRecords = new HashSet<String>();
            while (rs.next()) {
                if (firstRecords.contains(rs.getString(column))) continue;
                firstRecords.add(rs.getString(column));
            }
            conn.commit();
        }
        catch (Throwable throwable) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> sqlQuery1(String sql) throws Exception {
        long st = System.currentTimeMillis();
        int j = this.k++;
        LinkedList<Map<String, String>> results = new LinkedList<Map<String, String>>();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData meta = rs.getMetaData();
            int columncount = meta.getColumnCount();
            while (rs.next()) {
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                results.add(row);
                for (int i = 1; i <= columncount; ++i) {
                    String name = meta.getColumnName(i);
                    row.put(name, rs.getString(name));
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sqlRecordCount(String sql) {
        long st = System.currentTimeMillis();
        Connection conn = null;
        Statement stmt = null;
        int count = 0;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            count = rs.getInt(1);
        }
        catch (Exception e) {
            int n = 0;
            return n;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return count;
    }

    public long getSize() {
        long size = 0L;
        try {
            size = this.dbFile.length();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public String getDatabaseProfilerData() {
        return "Profiler is off";
    }

    public File getDBFile() {
        return this.dbFile;
    }
}

