/*
 * Decompiled with CFR 0.152.
 */
package com.binfer.providers.h2;

import com.binfer.base.service.IEnc;
import com.binfer.providers.h2.IConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.h2.jdbcx.JdbcDataSource;

class MiniConnectionPoolManager
implements IConnectionPool {
    private final JdbcDataSource dataSource = new JdbcDataSource();
    private final int maxConnections;
    private final long timeoutMs;
    private final Semaphore semaphore;
    private final PoolConnectionEventListener poolConnectionEventListener;
    private final ConcurrentLinkedQueue<PooledConnection> recycledConnections;
    private volatile boolean isDisposed = false;
    private volatile boolean doPurgeConnection = false;

    public MiniConnectionPoolManager(String DB_URL, String userid, String password, int maxConnections, int timeout) {
        this.dataSource.setURL(DB_URL);
        this.dataSource.setUser(userid);
        this.dataSource.setPassword(IEnc.DB_P1 + " " + IEnc.DB_P2);
        this.maxConnections = maxConnections;
        this.timeoutMs = (long)timeout * 1000L;
        this.semaphore = new Semaphore(maxConnections, true);
        this.recycledConnections = new ConcurrentLinkedQueue();
        this.poolConnectionEventListener = new PoolConnectionEventListener();
    }

    @Override
    public void close() throws SQLException {
        this.isDisposed = true;
        SQLException exception = null;
        while (!this.recycledConnections.isEmpty()) {
            PooledConnection pconn = this.recycledConnections.poll();
            try {
                if (pconn == null) continue;
                pconn.close();
            }
            catch (SQLException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.isDisposed) {
            throw new IllegalStateException("Connection pool has been disposed.");
        }
        try {
            if (!this.semaphore.tryAcquire(this.timeoutMs, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for a database connection.", e);
        }
        boolean success = false;
        try {
            Connection conn = this.getPooledConnection();
            success = true;
            Connection connection = conn;
            return connection;
        }
        finally {
            if (!success) {
                this.semaphore.release();
            }
        }
    }

    private Connection getPooledConnection() throws SQLException {
        PooledConnection pconn = this.recycledConnections.poll();
        if (pconn == null) {
            pconn = this.dataSource.getPooledConnection();
            pconn.addConnectionEventListener(this.poolConnectionEventListener);
        }
        try {
            return pconn.getConnection();
        }
        catch (SQLException e) {
            this.disposeConnection(pconn);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleConnection(PooledConnection pconn) {
        boolean shouldDispose = false;
        MiniConnectionPoolManager miniConnectionPoolManager = this;
        synchronized (miniConnectionPoolManager) {
            if (this.isDisposed || this.doPurgeConnection) {
                shouldDispose = true;
            } else {
                this.recycledConnections.offer(pconn);
            }
        }
        if (shouldDispose) {
            this.disposeConnection(pconn);
        } else {
            this.semaphore.release();
        }
    }

    private void disposeConnection(PooledConnection pconn) {
        pconn.removeConnectionEventListener(this.poolConnectionEventListener);
        try {
            pconn.close();
        }
        catch (SQLException e) {
            this.log("Error while closing database connection: " + e.getMessage());
        }
        finally {
            this.semaphore.release();
        }
    }

    public int getActiveConnections() {
        return this.maxConnections - this.semaphore.availablePermits();
    }

    public int getInactiveConnections() {
        return this.recycledConnections.size();
    }

    private void log(String msg) {
        System.err.println("MiniConnectionPoolManager: " + msg);
    }

    private class PoolConnectionEventListener
    implements ConnectionEventListener {
        private PoolConnectionEventListener() {
        }

        @Override
        public void connectionClosed(ConnectionEvent event) {
            MiniConnectionPoolManager.this.recycleConnection((PooledConnection)event.getSource());
        }

        @Override
        public void connectionErrorOccurred(ConnectionEvent event) {
            MiniConnectionPoolManager.this.disposeConnection((PooledConnection)event.getSource());
        }
    }

    public static class TimeoutException
    extends RuntimeException {
        public TimeoutException() {
            super("Timeout while waiting for a free database connection.");
        }
    }
}

