#!/bin/bash
#IA:050225: this script is able to install and auto start, but the desktop shortcut does not work
# === Configurable Variables ===
APP_NAME="binfer-sync-transfer"
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
LAUNCHER="$SCRIPT_DIR/startBinferSync.sh"
ICON_FILE="$SCRIPT_DIR/binfer_logo_blue_256.png"
DESKTOP_ENTRY_NAME="$APP_NAME.desktop"

# === Derived Paths ===
AUTOSTART_PATH="$HOME/.config/autostart"
AUTOSTART_FILE="$AUTOSTART_PATH/$APP_NAME.desktop"

DESKTOP_PATH="$HOME/Desktop"
#DESKTOP_PATH="$HOME/.local/share/applications"
#DESKTOP_PATH="/usr/share/applications"
DESKTOP_FILE="$DESKTOP_PATH/$DESKTOP_ENTRY_NAME"

echo "Installing Binfer from $SCRIPT_DIR..."

# Ensure launcher is executable
chmod +x "$LAUNCHER"
chmod +x $SCRIPT_DIR/uninstallBinferSync.sh

# === Create autostart entry ===
mkdir -p "$AUTOSTART_PATH"
cat > "$AUTOSTART_FILE" <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=Binfer
Comment=Start Binfer on login
Exec=$LAUNCHER
Icon=$ICON_FILE
Terminal=false
X-GNOME-Autostart-enabled=true
EOF

# === Create desktop shortcut ===
mkdir -p "$DESKTOP_PATH"
cat > "$DESKTOP_FILE" <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=Binfer
Comment=Launch Binfer
Exec=$LAUNCHER
Icon=$ICON_FILE
Terminal=false
Categories=Utility;
EOF

chmod +x "$DESKTOP_FILE"

# Trust the desktop file (for GNOME/Ubuntu)
if command -v gio >/dev/null; then
    gio set "$DESKTOP_FILE" "metadata::trusted" yes 2>/dev/null
fi

echo "Binfer installed. Shortcut added to Desktop. Launching now..."
"$LAUNCHER" &

echo "Installation complete."
exit 0
