#!/bin/bash

# === Configurable Variables ===
APP_NAME="binfer-sync-transfer"
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
LAUNCHER="$SCRIPT_DIR/startBinferSync.sh"
ICON_FILE="$SCRIPT_DIR/binfer-icon.png"
DESKTOP_ENTRY_NAME="$APP_NAME.desktop"

# === Derived Paths ===
AUTOSTART_FILE="$HOME/.config/autostart/$APP_NAME.desktop"
DESKTOP_FILE="$HOME/Desktop/$DESKTOP_ENTRY_NAME"

echo "Uninstalling Binfer..."

# === Stop running instance (best effort) ===
pkill -f "$LAUNCHER" 2>/dev/null

# === Remove desktop shortcut ===
if [ -f "$DESKTOP_FILE" ]; then
    rm -f "$DESKTOP_FILE"
    echo "Removed desktop shortcut: $DESKTOP_FILE"
else
    echo "Desktop shortcut not found at: $DESKTOP_FILE"
fi

# === Remove autostart entry ===
if [ -f "$AUTOSTART_FILE" ]; then
    rm -f "$AUTOSTART_FILE"
    echo "Removed autostart entry: $AUTOSTART_FILE"
else
    echo "Autostart entry not found at: $AUTOSTART_FILE"
fi

# === Remove application directory ===
if [ "$SCRIPT_DIR" != "$HOME" ] && [ -d "$SCRIPT_DIR" ]; then
    echo "Removing application directory: $SCRIPT_DIR"
    rm -rf "$SCRIPT_DIR"
else
    echo "Skipping deletion of directory: $SCRIPT_DIR (unexpected location or already removed)"
fi

echo "Uninstallation complete."
exit 0
